// RevorbWrapper.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"


int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 2)
	{
		_tprintf(_T("Usage: %s [cmdline]\n"), argv[0]);
		return 1;
	}

	// Build path to revorb.exe.
	// Start in same directory as the application.
	TCHAR szPath[MAX_PATH];
	LPTSTR szSlashPos = _tcsrchr(argv[0], _T('\\'));
	ZeroMemory(&szPath, sizeof(szPath));
	if (szSlashPos != NULL)
		_tcsncpy_s(szPath, argv[0], szSlashPos - argv[0] + 1);
	else
		_tcscat_s(szPath, argv[0]);
	_tcscat_s(szPath, _T("revorb.exe"));

	// Build command line
	TCHAR szCommandLine[MAX_PATH * 3 + 10];
	ZeroMemory(&szCommandLine, sizeof(szCommandLine));
	if (argc >= 3)
		_stprintf_s(szCommandLine, _T("\"%s\" \"%s\" \"%s\""), szPath, argv[1], argv[2]);
	else
		_stprintf_s(szCommandLine, _T("\"%s\" \"%s\""), szPath, argv[1]);

	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	// Start the child process.
	//_tprintf(_T("Command line: %s\n"), szCommandLine);
	// Prevent Windows crash dialog.
	SetErrorMode(SEM_NOGPFAULTERRORBOX);
	if (!CreateProcess(NULL,   // No module name (use command line)
		szCommandLine,  // Command line
		NULL,           // Process handle not inheritable
		NULL,           // Thread handle not inheritable
		FALSE,          // Set handle inheritance to FALSE
		0,              // No creation flags
		NULL,           // Use parent's environment block
		NULL,           // Use parent's starting directory 
		&si,            // Pointer to STARTUPINFO structure
		&pi))           // Pointer to PROCESS_INFORMATION structure
	{
		_tprintf(_T("CreateProcess failed (0x%lX).\n"), GetLastError());
		return 1;
	}

	// Wait until the child process exits.
	DWORD dwExitCode;
	if (WaitForSingleObject(pi.hProcess, INFINITE) == WAIT_OBJECT_0)
	{
		// Get exit code of the child process.
		if (GetExitCodeProcess(pi.hProcess, &dwExitCode))
		{
			// Check exit code of the child process.
			if (dwExitCode == STATUS_ACCESS_VIOLATION)
			{
				// Revorb has crashed with an access violation and may have left
				// an incomplete output file lying around.
				TCHAR szOutputFileName[MAX_PATH];
				ZeroMemory(&szOutputFileName, sizeof(szOutputFileName));
				if (argc >= 3)
				{
					// Output file specified on the command line.
					_tcscat_s(szOutputFileName, argv[2]);
				}
				else
				{
					// Output file not specified (overwrites input file).
					// Temporary output file is input file + ".tmp".
					_tcscat_s(szOutputFileName, argv[1]);
					_tcscat_s(szOutputFileName, _T(".tmp"));
				}
				if (!DeleteFile(szOutputFileName))
				{
					DWORD dwError = GetLastError();
					if (dwError != ERROR_FILE_NOT_FOUND)
					{
						_tprintf(_T("DeleteFile failed (0x%lX).\n"), dwError);
						dwExitCode = 1;
					}
				}
			}
		}
		else
		{
			_tprintf(_T("GetExitCodeProcess failed (0x%lX).\n"), GetLastError());
			dwExitCode = 1;
		}
	}
	else
	{
		_tprintf(_T("WaitForSingleObject failed (0x%lX).\n"), GetLastError());
		dwExitCode = 1;
	}

	// Close process and thread handles. 
	CloseHandle(pi.hProcess);
	CloseHandle(pi.hThread);

	return dwExitCode;
}
