@echo off
setlocal
set BUILDPRJ=RevorbWrapper.sln
set BUILDNAME=RevorbWrapper
set BUILDLOG=Build.log
echo %BUILDNAME% build running!
if exist "%BUILDLOG%" del "%BUILDLOG%"
if exist ".\Debug" rd ".\Debug" /s /q
if exist ".\Release" rd ".\Release" /s /q
set BUILDEXE=%ProgramFiles%\MSBuild\12.0\Bin\MSBuild.exe
if not exist "%BUILDEXE%" set BUILDEXE=%ProgramFiles(x86)%\MSBuild\12.0\Bin\MSBuild.exe
if not exist "%BUILDEXE%" (
	echo MSBuild 12 not found!
	goto error
)
set BUILDFLAGS=/m /v:minimal /nologo /noconsolelogger /fileLogger /fileLoggerParameters:Logfile="%BUILDLOG%";Append=true;Verbosity=minimal

set BUILDCFG=Debug
call :build
if errorlevel 1 goto error
echo.>>"%BUILDLOG%"
set BUILDCFG=Release
call :build
if errorlevel 1 goto error
goto done

:build
echo Building %BUILDCFG%...
echo *** Building %BUILDNAME%, Configuration %BUILDCFG% ***>>"%BUILDLOG%"
"%BUILDEXE%" "%BUILDPRJ%" /t:Rebuild /p:Configuration=%BUILDCFG% %BUILDFLAGS%
goto :eof

:done
echo.
echo Build successful.
echo.>>"%BUILDLOG%"
echo Build successful.>>"%BUILDLOG%"
goto end

:error
echo.
echo ****************************************
echo ! An error occurred !
echo ****************************************
echo.
echo Build failed.
echo.>>"%BUILDLOG%"
echo Build failed.>>"%BUILDLOG%"
pause

:end
endlocal
