using System;
using System.IO;
using System.Text;
using Ravioli.ArchiveInterface;

namespace Ravioli.SamplePlugin
{
	public class PakFile : GenericArchive
	{
		public override string TypeName
		{
			get { return "Quake PAK File (Sample)"; }
		}

		public override string[] Extensions
		{
			get { return new string[] { ".pak" }; }
		}

		protected override bool IsValidFormat(Stream stream, BinaryReader reader)
		{
			stream.Seek(0, SeekOrigin.Begin);
			uint signature = reader.ReadUInt32();
			return (signature == 0x4B434150); // "PACK" signature
		}

		protected override GenericDirectoryEntry[] ReadGenericDirectory(Stream stream, BinaryReader reader)
		{
			if (!IsValidFormat(stream, reader))
				throw new InvalidDataException("This is not a valid PAK file.");

			uint directoryOffset = reader.ReadUInt32();
			uint directorySize = reader.ReadUInt32();
			stream.Seek(directoryOffset, SeekOrigin.Begin);
			uint fileCount = directorySize / 64;
			GenericDirectoryEntry[] directory = new GenericDirectoryEntry[fileCount];
			for (uint i = 0; i < fileCount; i++)
			{
				GenericDirectoryEntry entry = new GenericDirectoryEntry();
				byte[] nameBytes = reader.ReadBytes(56);
				entry.Name = Encoding.GetEncoding(1252).GetString(nameBytes);
				int zeroPos = entry.Name.IndexOf('\0');
				if (zeroPos >= 0)
					entry.Name = entry.Name.Substring(0, zeroPos);
				entry.Offset = reader.ReadUInt32();
				entry.Length = reader.ReadUInt32();
				directory[i] = entry;
			}
			return directory;
		}
	}
}
